/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.CanvasColorMap;
import cds.aladin.CanvasPixelRange;
import cds.aladin.Plan;
import cds.aladin.PlanBG;
import cds.aladin.PlanImage;
import cds.aladin.PlanImageRGB;
import cds.tools.Util;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.image.IndexColorModel;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public final class FrameColorMap
extends JFrame
implements MouseListener {
    public static final String[] CM = new String[]{"gray", "BB", "Red", "Green", "Blue", "A", "stern"};
    public static final String[] CMA = new String[]{"gray", "BB", "Red", "Green", "Blue", "A", "stern"};
    private String CMTITRE;
    private String CMREVERSE;
    private String CMLIMITS;
    private String CMERRORRANGE;
    private String CMRESET;
    private String CMLOCALCUT;
    private String CMCLOSE;
    private String CMONVIEW;
    private String CMAPPLYALL;
    private String CMAPPLYCCD;
    private String CMMETHODERGB;
    private String CMMESSAGE;
    private String CMPIXTOOL;
    private String CMPREVIEW;
    private String CMFULLFITS;
    private String CMLOCALCUTTIP;
    private String CMMESSAGE1;
    private String CMMESSAGE2;
    private String CMAPPLYALLTIP;
    private String CMAPPLYCCDTIP;
    private String CMMETHOD;
    private String CMRESET1TIP;
    private String CMRESET2TIP;
    private String CMBACK;
    private String CMBACKTIP;
    private String CMNOCUT;
    private String CMNOCUTTIP;
    private String CMPREVIEWTIP;
    private String CMFULLFITSTIP;
    private String CMPIXTOOLTIP;
    private String CMONVIEWTIP;
    protected String CMCM;
    protected String CMRANGE;
    protected String CMRANGE1;
    private PlanImage pimg;
    private boolean isPlanImageRGB = false;
    private boolean isPlanBGRGB = false;
    private Vector<PlanImage> vimg;
    private Aladin aladin;
    private CanvasPixelRange canvasPixelRange = null;
    protected CanvasColorMap cm = null;
    protected CanvasColorMap cm2 = null;
    protected CanvasColorMap cm3 = null;
    private JPanel p = null;
    private JTextField pixelCutMinField;
    private JTextField pixelCutMaxField;
    private JComboBox<String> comboCM;
    private JButton localCutButton;
    private JButton getAllButton;
    private JButton resetAllButton;
    private JButton resetDistribButton;
    private JButton resetCMButton;
    private JButton applyOnAll;
    private JComboBox<String> cmCombo;
    private JComboBox<String> fctCombo;
    private JCheckBox reverseCb;
    private JRadioButton rPreview;
    private JRadioButton rFull;
    private DefaultConf defaultConf = new DefaultConf();
    private int imgID = -1;
    private static Insets MARGIN = new Insets(1, 3, 1, 3);
    private boolean flagHelp = true;

    protected void createChaine() {
        this.CMTITRE = Aladin.chaine.getString("CMTITRE");
        this.CMREVERSE = Aladin.chaine.getString("CMREVERSE");
        this.CMLIMITS = Aladin.chaine.getString("CMLIMITS");
        this.CMERRORRANGE = Aladin.chaine.getString("CMERRORRANGE");
        this.CMRESET = Aladin.chaine.getString("CMRESET");
        this.CMLOCALCUT = Aladin.chaine.getString("CMLOCALCUT");
        this.CMLOCALCUTTIP = Aladin.chaine.getString("CMLOCALCUTTIP");
        this.CMNOCUT = Aladin.chaine.getString("CMNOCUT");
        this.CMNOCUTTIP = Aladin.chaine.getString("CMNOCUTTIP");
        this.CMCLOSE = Aladin.chaine.getString("CMCLOSE");
        this.CMAPPLYALL = Aladin.chaine.getString("CMAPPLYALL");
        this.CMAPPLYCCD = Aladin.chaine.getString("CMAPPLYCCD");
        this.CMAPPLYALLTIP = Aladin.chaine.getString("CMAPPLYALLTIP");
        this.CMAPPLYCCDTIP = Aladin.chaine.getString("CMAPPLYCCDTIP");
        this.CMMETHODERGB = Aladin.chaine.getString("CMMETHODERGB");
        this.CMMESSAGE = Aladin.chaine.getString("CMMESSAGE");
        this.CMMESSAGE1 = Aladin.chaine.getString("CMMESSAGE1");
        this.CMMESSAGE2 = Aladin.chaine.getString("CMMESSAGE2");
        this.CMPIXTOOL = Aladin.chaine.getString("CMPIXTOOL");
        this.CMONVIEW = Aladin.chaine.getString("CMONVIEW");
        this.CMPREVIEW = Aladin.chaine.getString("CMPREVIEW");
        this.CMFULLFITS = Aladin.chaine.getString("CMFULLFITS");
        this.CMMETHOD = Aladin.chaine.getString("CMMETHOD");
        this.CMRESET1TIP = Aladin.chaine.getString("CMRESET1TIP");
        this.CMRESET2TIP = Aladin.chaine.getString("CMRESET2TIP");
        this.CMBACK = Aladin.chaine.getString("CMBACK");
        this.CMBACKTIP = Aladin.chaine.getString("CMBACKTIP");
        this.CMCM = Aladin.chaine.getString("CMCM");
        this.CMRANGE = Aladin.chaine.getString("CMRANGE");
        this.CMRANGE1 = Aladin.chaine.getString("CMRANGE1");
        this.CMPREVIEWTIP = Aladin.chaine.getString("CMPREVIEWTIP");
        this.CMFULLFITSTIP = Aladin.chaine.getString("CMFULLFITSTIP");
        this.CMPIXTOOLTIP = Aladin.chaine.getString("CMPIXTOOLTIP");
        this.CMONVIEWTIP = Aladin.chaine.getString("CMONVIEWTIP");
    }

    protected FrameColorMap(Aladin aladin) {
        this.aladin = aladin;
        Aladin.setIcon(this);
        this.createChaine();
        this.setTitle(this.CMTITRE);
        this.enableEvents(64L);
        Util.setCloseShortcut(this, true, aladin);
        this.getContentPane().setLayout(new BorderLayout(0, 0));
        this.setLocation(Aladin.computeLocation(this));
        this.addMouseListener(this);
    }

    void majCMByScript(PlanImage p) {
        if (p != this.pimg || p instanceof PlanImageRGB || p instanceof PlanBG && ((PlanBG)this.pimg).isColored()) {
            return;
        }
        this.pixelCutMinField.setText(p.getDataMinInfo());
        this.pixelCutMaxField.setText(p.getDataMaxInfo());
        if (this.comboCM != null) {
            this.comboCM.setSelectedIndex(p.typeCM);
        }
    }

    protected void majCM() {
        this.majCM(false);
    }

    protected void majCM(boolean force) {
        if (force) {
            this.pimg = null;
        }
        if (this.aladin.toolBox.tool[9].mode == -1) {
            this.memoControl();
            PlanImage p = this.aladin.calque.getFirstSelectedPlanImage();
            if (this.pimg != null && this.pimg.selected && !p.isPixel()) {
                p = this.pimg;
            }
            if (p != null && p.flagOk) {
                if (this.p == null || this.pimg != p) {
                    this.setTitle(this.CMTITRE + ": " + p.label);
                    this.initCM(p);
                    this.showCM();
                    if (!this.isPlanImageRGB && !this.isPlanBGRGB) {
                        this.cm.getCM();
                    }
                } else {
                    int nImgID = this.pimg.getImgID();
                    if (this.imgID == -1 || this.imgID != nImgID) {
                        this.cm.repaint();
                        if (this.cm2 != null) {
                            this.cm2.repaint();
                        }
                        if (this.cm3 != null) {
                            this.cm3.repaint();
                        }
                        this.imgID = nImgID;
                    }
                }
                if (!this.isVisible()) {
                    this.setVisible(true);
                }
                return;
            }
        }
        if (this.isVisible()) {
            this.dispose();
        }
    }

    protected void blinkUpdate(Plan pref) {
        if (this.pimg != pref) {
            return;
        }
        this.pimg.resetHist();
        this.imgID = -1;
        if (this.isVisible()) {
            this.majCM();
        }
    }

    protected void initCM(PlanImage pimg) {
        if (pimg == null) {
            return;
        }
        this.pimg = pimg;
        this.isPlanImageRGB = pimg instanceof PlanImageRGB;
        boolean bl = this.isPlanBGRGB = pimg instanceof PlanBG && ((PlanBG)pimg).isColored();
        if (this.isPlanImageRGB) {
            PlanImageRGB prgb = (PlanImageRGB)pimg;
            if (prgb.flagRed) {
                this.cm = new CanvasColorMap(this, pimg, 0);
            }
            if (prgb.flagGreen) {
                this.cm2 = new CanvasColorMap(this, pimg, 1);
            }
            if (prgb.flagBlue) {
                this.cm3 = new CanvasColorMap(this, pimg, 2);
            }
            this.cm.setOtherColorMap(this.cm2, this.cm3);
            if (this.cm2 != null) {
                this.cm2.setOtherColorMap(this.cm, this.cm3);
            }
            if (this.cm3 != null) {
                this.cm3.setOtherColorMap(this.cm, this.cm2);
            }
        } else if (this.isPlanBGRGB) {
            this.cm = new CanvasColorMap(this, pimg, 0);
            this.cm2 = new CanvasColorMap(this, pimg, 1);
            this.cm3 = new CanvasColorMap(this, pimg, 2);
            this.cm.setOtherColorMap(this.cm2, this.cm3);
            this.cm2.setOtherColorMap(this.cm, this.cm3);
            this.cm3.setOtherColorMap(this.cm, this.cm2);
        } else {
            this.canvasPixelRange = new CanvasPixelRange(this, pimg);
            this.cm = new CanvasColorMap(this, pimg);
        }
    }

    private void switchMode(PlanBG pbg) {
        pbg.switchFormat();
        this.showCM();
        this.aladin.view.repaintAll();
    }

    protected void showCM() {
        if (this.isPlanImageRGB || this.isPlanBGRGB) {
            this.showCMRGB();
        } else {
            this.showCMGrey();
        }
        this.resumeWidgets();
    }

    protected void resumeWidgets() {
        boolean hasSeveralImg;
        int cmIndex = this.pimg.typeCM;
        int fctIndex = this.pimg.getTransfertFct();
        int videoIndex = this.pimg.video;
        boolean fullPixel = this.pimg.hasAvailablePixels();
        boolean hasPreview = this.pimg instanceof PlanBG && (((PlanBG)this.pimg).inJPEG || ((PlanBG)this.pimg).inPNG) || !fullPixel;
        boolean hasFull = this.pimg instanceof PlanBG && ((PlanBG)this.pimg).inFits || fullPixel;
        boolean hasAll = this.pimg.pixelMin == this.pimg.dataMin && this.pimg.pixelMax == this.pimg.dataMax;
        boolean bl = hasSeveralImg = this.pimg.aladin.calque.getSelectedImagesWithPixels().size() >= 2;
        if (this.localCutButton != null) {
            this.localCutButton.setEnabled(fullPixel);
        }
        if (this.getAllButton != null) {
            this.getAllButton.setEnabled(fullPixel && !hasAll);
        }
        if (this.applyOnAll != null) {
            this.applyOnAll.setEnabled(hasSeveralImg && fullPixel || this.pimg.planMultiCCD != null);
        }
        if (this.applyOnAll != null) {
            this.applyOnAll.setText(this.pimg.planMultiCCD != null ? this.CMAPPLYCCD : this.CMAPPLYALL);
            Util.toolTip(this.applyOnAll, this.pimg.planMultiCCD != null ? this.CMAPPLYCCDTIP : this.CMAPPLYALLTIP, true);
        }
        if (this.rFull != null) {
            this.rFull.setSelected(fullPixel);
            this.rFull.setEnabled(hasFull);
        }
        if (this.rPreview != null) {
            this.rPreview.setSelected(!fullPixel);
            this.rPreview.setEnabled(hasPreview);
        }
        if (this.resetAllButton != null) {
            this.resetAllButton.setEnabled(this.defaultConf.isModif());
        }
        if (this.resetDistribButton != null) {
            this.resetDistribButton.setEnabled(this.defaultConf.isModifTriangle());
        }
        if (this.resetCMButton != null) {
            this.resetCMButton.setEnabled(this.defaultConf.isModifCM());
        }
        if (this.reverseCb != null) {
            this.reverseCb.setSelected(videoIndex == 1);
        }
        if (this.cmCombo != null) {
            this.cmCombo.setSelectedIndex(cmIndex);
        }
        if (this.fctCombo != null) {
            this.fctCombo.setSelectedIndex(fctIndex);
        }
        if (this.pixelCutMinField != null) {
            this.pixelCutMinField.setText(this.pimg.getPixelMinInfo());
            this.pixelCutMinField.setEnabled(fullPixel);
        }
        if (this.pixelCutMaxField != null) {
            this.pixelCutMaxField.setText(this.pimg.getPixelMaxInfo());
            this.pixelCutMaxField.setEnabled(fullPixel);
        }
        if (this.aladin.frameAllsky != null) {
            this.aladin.frameAllsky.updateCurrentCM();
        }
        this.cm.resumePixelTool();
        this.updatePlanRgb();
        if (this.canvasPixelRange != null) {
            this.canvasPixelRange.repaint();
        }
        this.cm.repaint();
        this.pimg.aladin.calque.repaintAll();
        this.defaultConf.memo();
    }

    private void updatePlanRgb() {
        if (this.pimg instanceof PlanBG && ((PlanBG)this.pimg).hasRecutListener()) {
            this.pimg.recut();
        }
    }

    private JPanel createPanelTop() {
        JButton b;
        JRadioButton r;
        ButtonGroup gr = new ButtonGroup();
        JPanel p = new JPanel(new BorderLayout(0, 0));
        JPanel pLeft = new JPanel(new FlowLayout());
        this.rPreview = r = new JRadioButton(this.CMPREVIEW);
        pLeft.add(r);
        gr.add(r);
        Util.toolTip(r, this.CMPREVIEWTIP, true);
        r.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FrameColorMap.this.switchMode((PlanBG)FrameColorMap.this.pimg);
            }
        });
        this.rFull = r = new JRadioButton(this.CMFULLFITS);
        pLeft.add(r);
        gr.add(r);
        Util.toolTip(r, this.CMFULLFITSTIP, true);
        r.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FrameColorMap.this.switchMode((PlanBG)FrameColorMap.this.pimg);
            }
        });
        p.add((Component)pLeft, "West");
        JPanel pRight = new JPanel(new FlowLayout());
        this.localCutButton = b = this.getButton(this.CMLOCALCUT);
        Util.toolTip(b, this.CMLOCALCUTTIP, true);
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FrameColorMap.this.localcut();
                FrameColorMap.this.resumeWidgets();
            }
        });
        pRight.add(b);
        this.getAllButton = b = this.getButton(this.CMNOCUT);
        Util.toolTip(b, this.CMNOCUTTIP, true);
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FrameColorMap.this.getAll();
                FrameColorMap.this.resumeWidgets();
            }
        });
        pRight.add(b);
        this.resetAllButton = b = this.getButton(this.CMBACK);
        Util.toolTip(b, this.CMBACKTIP, true);
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FrameColorMap.this.defaultConf.resetAll();
                FrameColorMap.this.resumeWidgets();
            }
        });
        pRight.add(b);
        pRight.add(Util.getHelpButton(this, this.CMMESSAGE));
        p.add((Component)pRight, "East");
        return p;
    }

    private JPanel createPanelDistribution() {
        JPanel p1 = new JPanel(new BorderLayout(0, 2));
        p1.add((Component)this.createPanelPixelCut(), "North");
        p1.add((Component)this.cm, "Center");
        p1.add((Component)this.createPanelClose(), "South");
        JPanel pHelp = new JPanel(new GridLayout(2, 1, 0, 140));
        JButton b = Util.getHelpButton(this, this.CMMESSAGE1);
        pHelp.add(b);
        b = Util.getHelpButton(this, this.CMMESSAGE2);
        pHelp.add(b);
        JPanel p = new JPanel(new FlowLayout());
        p.add(pHelp);
        p.add(p1);
        p.add(this.createPanelDistributionButton());
        return p;
    }

    private JPanel createPanelDistributionButton() {
        JCheckBox cc;
        JButton b;
        GridBagLayout g = new GridBagLayout();
        JPanel p = new JPanel(g);
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 0;
        c.anchor = 10;
        c.insets = new Insets(2, 2, 2, 2);
        JLabel l = new JLabel(Util.fold(this.CMMETHOD, 30, true));
        l.setForeground(Aladin.MYBLUE);
        c.insets.bottom = 10;
        c.insets.top = 10;
        c.gridwidth = 2;
        c.gridx = 0;
        ++c.gridy;
        g.setConstraints(l, c);
        p.add(l);
        this.resetDistribButton = b = this.getButton(this.CMRESET);
        Util.toolTip(b, this.CMRESET1TIP, true);
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FrameColorMap.this.defaultConf.resetTriangle();
                FrameColorMap.this.resumeWidgets();
            }
        });
        c.gridwidth = 1;
        c.insets.top = 2;
        c.insets.bottom = 2;
        ++c.gridy;
        g.setConstraints(b, c);
        p.add(b);
        this.reverseCb = cc = new JCheckBox(this.CMREVERSE);
        cc.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FrameColorMap.this.reverse();
                FrameColorMap.this.resumeWidgets();
            }
        });
        c.gridwidth = 2;
        c.insets.top = 25;
        ++c.gridy;
        c.anchor = 21;
        g.setConstraints(cc, c);
        p.add(cc);
        JPanel p1 = new JPanel(new GridLayout(1, 2, 1, 1));
        JComboBox<String> cb = FrameColorMap.createComboCM();
        this.cmCombo = cb;
        cb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FrameColorMap.this.changeCM((JComboBox)e.getSource());
                FrameColorMap.this.resumeWidgets();
            }
        });
        p1.add(cb);
        cb = FrameColorMap.createComboFct();
        this.fctCombo = cb;
        cb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FrameColorMap.this.changeTransfertFct();
                FrameColorMap.this.resumeWidgets();
            }
        });
        p1.add(cb);
        c.insets.top = 2;
        ++c.gridy;
        c.anchor = 10;
        g.setConstraints(p1, c);
        p.add(p1);
        this.resetCMButton = b = this.getButton(this.CMRESET);
        Util.toolTip(b, this.CMRESET2TIP, true);
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FrameColorMap.this.defaultConf.resetCM();
                FrameColorMap.this.resumeWidgets();
            }
        });
        c.gridwidth = 1;
        ++c.gridy;
        g.setConstraints(b, c);
        p.add(b);
        b = this.getButton(this.CMONVIEW);
        Util.toolTip(b, this.CMONVIEWTIP, true);
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((FrameColorMap)FrameColorMap.this).aladin.view.showRainbow(true);
                ((FrameColorMap)FrameColorMap.this).aladin.view.repaintAll();
            }
        });
        ++c.gridx;
        c.anchor = 22;
        g.setConstraints(b, c);
        p.add(b);
        return p;
    }

    private JPanel createPanelPixelCut() {
        JPanel p = new JPanel(new BorderLayout(0, 0));
        p.setBorder(BorderFactory.createEmptyBorder());
        this.pixelCutMinField = new JTextField(this.pimg.getPixelMinInfo(), 8);
        this.pixelCutMinField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    FrameColorMap.this.changeCut();
                }
            }
        });
        p.add((Component)this.pixelCutMinField, "West");
        this.pixelCutMaxField = new JTextField(this.pimg.getPixelMaxInfo(), 8);
        this.pixelCutMaxField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    FrameColorMap.this.changeCut();
                }
            }
        });
        p.add((Component)this.pixelCutMaxField, "East");
        JPanel p1 = new JPanel();
        JLabel titre = new JLabel(this.CMLIMITS);
        titre.setForeground(Aladin.MYBLUE);
        p1.add(titre);
        p.add((Component)p1, "Center");
        return p;
    }

    private JPanel createPanelClose() {
        JButton b;
        JPanel p2 = new JPanel();
        this.applyOnAll = b = this.getButton(this.CMAPPLYALL);
        Util.toolTip(b, this.CMAPPLYALLTIP, true);
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FrameColorMap.this.applyOnOtherImg();
                FrameColorMap.this.resumeWidgets();
            }
        });
        p2.add(b);
        b = this.getButton(this.CMPIXTOOL);
        Util.toolTip(b, this.CMPIXTOOLTIP, true);
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FrameColorMap.this.aladin.pixelTool();
            }
        });
        p2.add(b);
        b = this.getButton(this.CMCLOSE);
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FrameColorMap.this.dispose();
            }
        });
        p2.add(b);
        return p2;
    }

    private void showCMGrey() {
        if (this.p != null) {
            this.getContentPane().remove(this.p);
        }
        JPanel p1 = new JPanel(new BorderLayout(0, 0));
        p1.add((Component)this.createPanelTop(), "North");
        p1.add((Component)this.canvasPixelRange, "Center");
        this.p = new JPanel(new BorderLayout(0, 0));
        this.p.add((Component)p1, "North");
        this.p.add((Component)this.createPanelDistribution(), "Center");
        this.getContentPane().add((Component)this.p, "Center");
        this.pack();
        this.setVisible(true);
        this.toFront();
    }

    private void showCMRGB() {
        if (this.p != null) {
            this.getContentPane().remove(this.p);
        }
        this.p = new JPanel();
        GridBagLayout g = new GridBagLayout();
        this.p.setLayout(g);
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.anchor = 10;
        c.gridwidth = 0;
        c.insets = new Insets(0, 0, 0, 0);
        JPanel p1 = new JPanel();
        JLabel methode = new JLabel(Util.fold(this.CMMETHODERGB, 80, true));
        methode.setFont(methode.getFont().deriveFont(2));
        p1.add(methode);
        p1.add(Util.getHelpButton(this, this.CMMESSAGE));
        g.setConstraints(p1, c);
        this.p.add(p1);
        if (this.isPlanBGRGB) {
            g.setConstraints(this.cm, c);
            this.p.add(this.cm);
            g.setConstraints(this.cm2, c);
            this.p.add(this.cm2);
            g.setConstraints(this.cm3, c);
            this.p.add(this.cm3);
        } else {
            if (((PlanImageRGB)this.pimg).flagRed) {
                g.setConstraints(this.cm, c);
                this.p.add(this.cm);
            }
            if (((PlanImageRGB)this.pimg).flagGreen) {
                g.setConstraints(this.cm2, c);
                this.p.add(this.cm2);
            }
            if (((PlanImageRGB)this.pimg).flagBlue) {
                g.setConstraints(this.cm3, c);
                this.p.add(this.cm3);
            }
        }
        JPanel validation = new JPanel();
        JButton b = this.getButton(this.CMREVERSE);
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FrameColorMap.this.reverse();
                FrameColorMap.this.resumeWidgets();
            }
        });
        validation.add(b);
        validation.add(new JLabel("  "));
        b = this.getButton(this.CMRESET);
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FrameColorMap.this.resetRGB();
                FrameColorMap.this.resumeWidgets();
            }
        });
        validation.add(b);
        b = this.getButton(this.CMCLOSE);
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FrameColorMap.this.dispose();
            }
        });
        validation.add(b);
        g.setConstraints(validation, c);
        this.p.add(validation);
        this.getContentPane().add((Component)this.p, "Center");
        this.pack();
        this.setVisible(true);
        this.toFront();
    }

    private void resetRGB() {
        if (this.isPlanBGRGB) {
            ((PlanBG)this.pimg).filterRGB(new int[]{0, 128, 255}, 0);
            ((PlanBG)this.pimg).filterRGB(new int[]{0, 128, 255}, 1);
            ((PlanBG)this.pimg).filterRGB(new int[]{0, 128, 255}, 2);
            this.cm.reset();
            this.cm2.reset();
            this.cm3.reset();
        } else {
            if (((PlanImageRGB)this.pimg).flagRed) {
                this.cm.reset();
            }
            if (((PlanImageRGB)this.pimg).flagGreen) {
                this.cm2.reset();
            }
            if (((PlanImageRGB)this.pimg).flagBlue) {
                this.cm3.reset();
            }
            ((PlanImageRGB)this.pimg).createImgRGB();
        }
    }

    private JButton getButton(String label) {
        JButton b = new JButton(label);
        b.setMargin(MARGIN);
        return b;
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(200, 300);
    }

    protected static JComboBox<String> createComboCM() {
        JComboBox<String> c = new JComboBox<String>();
        for (String s : CanvasColorMap.getCMList()) {
            c.addItem(s);
        }
        c.addItem(" -- ");
        return c;
    }

    protected static JComboBox<String> createComboFct() {
        JComboBox<String> c = new JComboBox<String>(PlanImage.TRANSFERTFCT);
        return c;
    }

    protected final boolean isDragging() {
        return this.cm == null ? false : this.cm.isDragging();
    }

    private void localcut() {
        this.localcut(this.pimg);
        this.resumeWidgets();
    }

    public void localcut(PlanImage pimg) {
        if (pimg instanceof PlanBG) {
            ((PlanBG)pimg).forceReload();
        } else {
            pimg.recut(0.0, 0.0, true);
        }
        this.aladin.view.repaintAll();
    }

    private void reverse() {
        this.pimg.video = this.pimg.video == 0 ? 1 : 0;
        this.aladin.console.printCommand("cm " + (this.pimg.video == 0 ? "noreverse" : "reverse"));
        if (this.pimg.type == 2) {
            if (((PlanImageRGB)this.pimg).flagRed) {
                this.cm.pimg.video = this.pimg.video;
                this.cm.repaint();
            }
            if (((PlanImageRGB)this.pimg).flagGreen) {
                this.cm2.pimg.video = this.pimg.video;
                this.cm2.repaint();
            }
            if (((PlanImageRGB)this.pimg).flagBlue) {
                this.cm3.pimg.video = this.pimg.video;
                this.cm3.repaint();
            }
            ((PlanImageRGB)this.pimg).inverseRGB();
        } else {
            this.cm.repaint();
            this.setCM(this.cm.getCM());
        }
        this.aladin.view.repaintAll();
        this.aladin.calque.zoom.zoomView.repaint();
    }

    private void getAll() {
        if (this.pimg == null) {
            return;
        }
        Aladin.makeCursor(this, 1);
        this.pixelCutMinField.setText(this.pimg.getDataMinInfo());
        this.pixelCutMaxField.setText(this.pimg.getDataMaxInfo());
        Aladin.makeCursor(this, 1);
        if (!this.pimg.recut(this.pimg.dataMin, this.pimg.dataMax, false)) {
            Aladin.makeCursor(this, 0);
            return;
        }
        Aladin.makeCursor(this, 0);
        this.aladin.console.printCommand("cm all");
        this.cm.repaint();
        this.canvasPixelRange.repaint();
        this.setCM(this.cm.getCM());
        this.aladin.view.repaintAll();
        this.aladin.calque.zoom.zoomView.repaint();
    }

    private void changeTransfertFct() {
        int n = this.fctCombo.getSelectedIndex();
        if (this.pimg.getTransfertFct() == n) {
            return;
        }
        this.aladin.console.printCommand("cm " + PlanImage.TRANSFERTFCT[n]);
        this.pimg.setTransfertFct(n);
        this.setCM(this.cm.getCM());
        this.aladin.view.repaintAll();
        this.aladin.calque.zoom.zoomView.repaint();
        this.repaint();
    }

    private void applyOnOtherImg() {
        this.vimg = this.pimg.planMultiCCD != null ? this.pimg.planMultiCCD.getCCD() : this.aladin.calque.getSelectedImagesWithPixels();
        this.vimg.remove(this.pimg);
        final String mins = this.pixelCutMinField.getText();
        final String maxs = this.pixelCutMaxField.getText();
        final int video = this.pimg.video;
        final int typeCM = this.pimg.typeCM;
        final int indexFct = this.pimg.getTransfertFct();
        final int[] tr = new int[3];
        for (int i = 0; i < 3; ++i) {
            tr[i] = this.pimg.cmControl[i];
        }
        new Thread("changeAutocut"){

            @Override
            public void run() {
                Enumeration e = FrameColorMap.this.vimg.elements();
                while (e.hasMoreElements()) {
                    PlanImage pi = (PlanImage)e.nextElement();
                    double min = pi.getPixelValue(mins);
                    double max = pi.getPixelValue(maxs);
                    pi.recut(min, max, false);
                    pi.setTransfertFct(indexFct);
                    pi.video = video;
                    pi.typeCM = typeCM;
                    CanvasColorMap cfr_ignored_0 = FrameColorMap.this.cm;
                    pi.setCM(CanvasColorMap.getCM(tr[0], tr[1], tr[2], video == 1, typeCM, indexFct, pi.isTransparent()));
                    for (int i = 0; i < 3; ++i) {
                        pi.cmControl[i] = tr[i];
                    }
                    ((FrameColorMap)FrameColorMap.this).aladin.view.repaintAll();
                }
                FrameColorMap.this.vimg = null;
            }
        }.start();
    }

    protected void setMinMax(double min, double max, boolean execute) {
        this.pixelCutMinField.setText(Util.myRound(min));
        this.pixelCutMaxField.setText(Util.myRound(max));
        if (execute) {
            this.changeCut();
            this.resumeWidgets();
        }
    }

    private void changeCut() {
        try {
            double min = this.pimg.getPixelValue(this.pixelCutMinField.getText());
            double max = this.pimg.getPixelValue(this.pixelCutMaxField.getText());
            if (min > max) {
                Aladin.error(this, this.CMERRORRANGE);
                return;
            }
            this.aladin.console.printCommand("cm " + this.pixelCutMinField.getText() + ".." + this.pixelCutMaxField.getText());
            if (!this.pimg.recut(min, max, false)) {
                return;
            }
            this.pimg.resetHist();
            this.setCM(this.cm.getCM());
            this.pixelCutMinField.setText(this.pimg.getPixelMinInfo());
            this.pixelCutMaxField.setText(this.pimg.getPixelMaxInfo());
            this.canvasPixelRange.repaint();
            this.aladin.view.repaintAll();
            this.aladin.calque.zoom.zoomView.repaint();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void changeCM(JComboBox<String> c) {
        int n = c.getSelectedIndex();
        if (n == this.pimg.typeCM) {
            return;
        }
        this.pimg.typeCM = n;
        this.cm.repaint();
        if (n < CMA.length) {
            this.aladin.console.printCommand("cm " + CMA[n]);
        } else {
            try {
                this.aladin.console.printCommand("cm " + CanvasColorMap.customCMName.get(n - 6 - 1));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            this.setCM(this.cm.getCM());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.aladin.view.repaintAll();
        this.aladin.calque.zoom.zoomView.repaint();
    }

    private void setCM(IndexColorModel ic) {
        this.pimg.setCM(ic);
        this.pimg.aladin.calque.zoom.zoomView.setCM(ic);
    }

    private void memoControl() {
        if (this.pimg == null || this.cm == null) {
            return;
        }
        if (this.isPlanImageRGB) {
            for (int i = 0; i < 3; ++i) {
                PlanImageRGB pRGB = (PlanImageRGB)this.pimg;
                if (pRGB.flagRed) {
                    pRGB.RGBControl[i] = this.cm.triangle[i];
                }
                if (pRGB.flagGreen) {
                    pRGB.RGBControl[3 + i] = this.cm2.triangle[i];
                }
                if (!pRGB.flagBlue) continue;
                pRGB.RGBControl[6 + i] = this.cm3.triangle[i];
            }
        } else if (this.isPlanBGRGB) {
            for (int i = 0; i < 3; ++i) {
                PlanBG pbg = (PlanBG)this.pimg;
                pbg.RGBControl[i] = this.cm.triangle[i];
                pbg.RGBControl[3 + i] = this.cm2.triangle[i];
                pbg.RGBControl[6 + i] = this.cm3.triangle[i];
            }
        } else {
            for (int i = 0; i < 3; ++i) {
                this.pimg.cmControl[i] = this.cm.triangle[i];
            }
        }
    }

    protected void disposeFrameCM(Plan p) {
        if (p != this.pimg) {
            return;
        }
        this.pimg = null;
        this.imgID = -1;
        if (this.isVisible()) {
            this.aladin.toolBox.tool[9].setMode(1);
            this.aladin.toolBox.repaint();
            this.setVisible(false);
        }
    }

    @Override
    public void dispose() {
        this.setVisible(false);
        this.aladin.gc();
        this.memoControl();
        if (this.aladin.calque.getPlanBase() != null) {
            this.aladin.toolBox.tool[9].setMode(1);
        } else {
            this.aladin.toolBox.tool[9].setMode(0);
        }
        this.aladin.toolBox.repaint();
        this.imgID = -1;
    }

    @Override
    protected void processWindowEvent(WindowEvent e) {
        if (e.getID() == 201) {
            this.dispose();
        }
        super.processWindowEvent(e);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        if (this.ignoreMouse(e)) {
            return;
        }
        this.resumeWidgets();
    }

    protected void help() {
        if (this.flagHelp && this.aladin.configuration.isHelp()) {
            this.aladin.configuration.showHelpIfOk("HPIXEL");
            this.flagHelp = false;
        }
    }

    @Override
    public void show() {
        super.show();
        this.help();
    }

    @Override
    public void mouseExited(MouseEvent e) {
        if (this.ignoreMouse(e)) {
            return;
        }
        if (this.pixelCutMinField != null && this.pixelCutMaxField != null) {
            String mins = this.pixelCutMinField.getText();
            String maxs = this.pixelCutMaxField.getText();
            if (!mins.equals(this.pimg.getPixelMinInfo()) || !maxs.equals(this.pimg.getPixelMaxInfo())) {
                this.resumeWidgets();
            }
        } else {
            this.resumeWidgets();
        }
    }

    private boolean ignoreMouse(MouseEvent e) {
        int x = e.getX();
        int y = e.getY();
        return x >= 10 && y >= 30 && x <= this.getWidth() - 10 && y <= this.getHeight() - 10;
    }

    class DefaultConf {
        double rawPixelCutMin;
        double rawPixelCutMax;
        int cmIndex;
        int fctIndex;
        int videoIndex;
        long pimgHash;

        DefaultConf() {
        }

        boolean memo() {
            if ((long)FrameColorMap.this.pimg.hashCode() == this.pimgHash) {
                return false;
            }
            this.pimgHash = FrameColorMap.this.pimg.hashCode();
            this.rawPixelCutMin = ((FrameColorMap)FrameColorMap.this).pimg.pixelMin;
            this.rawPixelCutMax = ((FrameColorMap)FrameColorMap.this).pimg.pixelMax;
            this.cmIndex = ((FrameColorMap)FrameColorMap.this).pimg.typeCM;
            this.fctIndex = FrameColorMap.this.pimg.getTransfertFct();
            this.videoIndex = ((FrameColorMap)FrameColorMap.this).pimg.video;
            return true;
        }

        void resetAll() {
            this.resetMinMax();
            this.resetCM();
            this.resetTriangle();
        }

        boolean isModif() {
            return this.isModifCM() || this.isModifTriangle() || this.isModifMinMax();
        }

        boolean isModifCM() {
            return FrameColorMap.this.pimg.getTransfertFct() != this.fctIndex || ((FrameColorMap)FrameColorMap.this).pimg.typeCM != this.cmIndex || ((FrameColorMap)FrameColorMap.this).pimg.video != this.videoIndex;
        }

        void resetCM() {
            if (!this.isModifCM()) {
                return;
            }
            FrameColorMap.this.pimg.setTransfertFct(this.fctIndex);
            ((FrameColorMap)FrameColorMap.this).pimg.typeCM = this.cmIndex;
            ((FrameColorMap)FrameColorMap.this).pimg.video = this.videoIndex;
            FrameColorMap.this.setCM(FrameColorMap.this.cm.getCM());
        }

        boolean isModifTriangle() {
            return 0 != FrameColorMap.this.cm.triangle[0] || 128 != FrameColorMap.this.cm.triangle[1] || 255 != FrameColorMap.this.cm.triangle[2];
        }

        void resetTriangle() {
            if (!this.isModifTriangle()) {
                return;
            }
            FrameColorMap.this.cm.reset();
            FrameColorMap.this.setCM(FrameColorMap.this.cm.getCM());
        }

        boolean isModifMinMax() {
            return this.rawPixelCutMin != ((FrameColorMap)FrameColorMap.this).pimg.pixelMin || this.rawPixelCutMax != ((FrameColorMap)FrameColorMap.this).pimg.pixelMax;
        }

        void resetMinMax() {
            if (!this.isModifMinMax()) {
                return;
            }
            FrameColorMap.this.pimg.recut(this.rawPixelCutMin, this.rawPixelCutMax, false);
            FrameColorMap.this.setCM(FrameColorMap.this.cm.getCM());
            FrameColorMap.this.pixelCutMinField.setText(FrameColorMap.this.pimg.getPixelMinInfo());
            FrameColorMap.this.pixelCutMaxField.setText(FrameColorMap.this.pimg.getPixelMaxInfo());
        }
    }
}

